IF OBJECT_ID('P_EXP_CTB_MOV_IMP_DEV_VENDA') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_IMP_DEV_VENDA
	END
 
GO
 
CREATE PROCEDURE P_EXP_CTB_MOV_IMP_DEV_VENDA( @CD_EMP		INT,
											   @CD_FILIAL	INT,
											   @DT_INI		DATETIME,
											   @DT_FIM		DATETIME,
											   @FLAG_LIMPAR INT=0)		
	

WITH ENCRYPTION AS  
SET NOCOUNT ON;
BEGIN TRY
BEGIN
	
	DECLARE @RS_CD_EMP				INT
	DECLARE @RS_CD_FILIAL			INT 
	DECLARE @RS_NM_FANT				VARCHAR(100)
	DECLARE @RS_DT_EMI_NF			DATETIME
	DECLARE @RS_DS_MOV_OP			VARCHAR(100)
	DECLARE @RS_CD_MOV_OP			INT
	DECLARE @RS_VLR_BASE_PIS_COFINS MONEY
	DECLARE @RS_VLR_ICMS_ITENS		MONEY
    
	DECLARE @RET_CD_FILIAL					INT
	DECLARE @RET_CD_MOV_OP					INT 
	DECLARE @RET_DS_MOV_OP_CONTABIL			VARCHAR(100)
	DECLARE @RET_CNT_CENTRO_CUSTO			VARCHAR(20)
	DECLARE @RET_DS_CENTRO_CUSTO			VARCHAR(100)
	DECLARE @RET_FLAG_APLICAR_CENTRO_CUSTO 	INT
	DECLARE @RET_CD_CTB_CNT					VARCHAR(100)
	DECLARE @RET_CD_CTB_CNT_RED				INT	
	
    DECLARE @PERC_COFINS			MONEY
    DECLARE @PERC_PIS				MONEY
    
    DECLARE @VLR_COFINS				MONEY
    DECLARE @VLR_PIS				MONEY

    DECLARE @NR_CONTROLE			VARCHAR (12)
    
    SET @PERC_COFINS = ISNULL((SELECT TOP 1 PERC_IMP FROM GLB_IMPOSTOS WHERE TIPO_IMPOSTO = 2),0)
	SET @PERC_PIS    = ISNULL((SELECT TOP 1 PERC_IMP FROM GLB_IMPOSTOS WHERE TIPO_IMPOSTO = 1),0)
    
	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA  ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR
	
	--@TP_CONTA
	--TipoEstoque = 0
    --TipoIcmsPagar = 1
    --TipoIcmsRecuperar = 2
    --TipoPisRecuperar = 3
    --TipoPisPagar = 4
    --TipoCofinsRecuperar = 5
    --TipoCofinsPagar = 6
    --TipoIcmsSubst = 7	
	
	DECLARE RS_RESULT
	CURSOR FOR 								
		SELECT 
			V_EST_NF_ENT.CD_EMP,
			V_EST_NF_ENT.CD_FILIAL,
			PRC_FILIAL.NM_FANT,
			V_EST_NF_ENT.DT_ENT AS DT_EMI_NF,
			V_EST_NF_ENT.DS_MOV_OP,
			V_EST_NF_ENT.CD_MOV_OP,
			SUM(CASE WHEN PIS_COFINS = 1 THEN VLR_TOT_IT ELSE 0 END) VLR_BASE_PIS_COFINS,
			SUM(VLR_ICMS_IT) AS VLR_ICMS_ITENS
		
		FROM V_EST_NF_ENT 
			INNER JOIN PRC_FILIAL ON 
				V_EST_NF_ENT.CD_EMP = PRC_FILIAL.CD_EMP AND 
				V_EST_NF_ENT.CD_FILIAL = PRC_FILIAL.CD_FILIAL 
	    
		WHERE 
			V_EST_NF_ENT.CD_EMP			= @CD_EMP 
			AND V_EST_NF_ENT.CD_FILIAL	= @CD_FILIAL 
			AND V_EST_NF_ENT.DT_ENT		BETWEEN @DT_INI AND @DT_FIM 
			AND V_EST_NF_ENT.TP_MOV		= 11
			
		GROUP BY
			V_EST_NF_ENT.CD_EMP,
			V_EST_NF_ENT.CD_FILIAL,
			DS_MOV_OP,NM_FANT,DT_ENT,
			V_EST_NF_ENT.CD_MOV_OP


		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
				@RS_CD_EMP, 
				@RS_CD_FILIAL,
				@RS_NM_FANT,
				@RS_DT_EMI_NF,
				@RS_DS_MOV_OP,
				@RS_CD_MOV_OP,
				@RS_VLR_BASE_PIS_COFINS,
				@RS_VLR_ICMS_ITENS		
 

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN
			
				IF @RS_VLR_ICMS_ITENS > 0
					BEGIN
						SELECT 
							@RET_CD_FILIAL					= CD_FILIAL,							
						     @RET_DS_MOV_OP_CONTABIL			= DS_MOV_OP_CONTABIL,
							@RET_CNT_CENTRO_CUSTO			= CNT_CENTRO_CUSTO,
							@RET_DS_CENTRO_CUSTO			= DS_CENTRO_CUSTO,
							@RET_FLAG_APLICAR_CENTRO_CUSTO 	= ISNULL(FLAG_APLICAR_CENTRO_CUSTO,0),
							@RET_CD_CTB_CNT					= CD_CTB_CNT,
							@RET_CD_CTB_CNT_RED				= CD_CTB_CNT_RED						
						FROM UFD_BUSCA_CONTA_MOV (@RS_CD_EMP, @RS_CD_MOV_OP, 1, 1, @RS_CD_FILIAL)
						
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
							 RIGHT('00'+ CAST( DAY( @RS_DT_EMI_NF) AS VARCHAR),2) + 
								RIGHT('00'+  CAST( MONTH(@RS_DT_EMI_NF) AS VARCHAR),2) + 
								     RIGHT('00'+ CAST( YEAR(@RS_DT_EMI_NF)AS VARCHAR),2) + 
									   RIGHT('00'+ CAST( YEAR(@RS_CD_MOV_OP)AS VARCHAR),2) + '1'						  					  

						------------------------------------------------------------------------------------------------------------------
						--ICMS A RECUPERAR - Ctb_Cnt_Movimento_Icms_Recuperar
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV 

										  (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)
											
								SELECT
									     @RS_CD_EMP					,								--CD_EMP
										@CD_FILIAL					,								--CD_FILIAL_EXPORT
										@RS_CD_FILIAL				,								--CD_FILIAL
										7 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
										'DEVOLUCAO DE VENDAS'		,								--MOVIMENTO								
										''							,								--OPERACAO
										'DEVOLUCAO ICMS - DEBITO'	,								--OPERACAO_DEBITO	
										0							,								--CD_CNT_RED_CREDITO
										''							,								--CD_CNT_CREDITO
										@RET_CD_CTB_CNT_RED			,								--CD_CNT_RED_DEBITO
										@RET_CD_CTB_CNT				,								--CD_CNT_DEBITO										
										@RS_DT_EMI_NF		,										--DT_MOV
										'VR. REF. ICMS S/DEVOLUCAO DE VENDAS CONF. DOC(S) EMITIDOS',--HIST
										@RS_VLR_ICMS_ITENS,											--VLR_LANC
										'D'			,												--TP_TRANSA
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN 1 ELSE 0 END) , --RATEIO_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_DS_CENTRO_CUSTO 	ELSE '' END),--DS_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_CNT_CENTRO_CUSTO 	ELSE '' END),--CNT_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RS_VLR_ICMS_ITENS 		ELSE 0 END),--VLR_CENTRO_CUSTO									
										'NAT MOV 1-ICMS PAGAR'				,						--ORIG_CONTA
										@RS_CD_MOV_OP		,										--COD_CONTA								
										OBJECT_NAME(@@PROCID)										--NM_PROCEDURE	
									   , 'X' AS TIPO_LANCTO
									   , 0 AS CD_EVENTO
									   , 0  AS NR_DP
									   , 0  AS ANO
									   , @NR_CONTROLE AS NR_DOC
									   ,'' AS CD_BC_LANC;
						------------------------------------------------------------------------------------------------------------------
						--ICMS A RECUPERAR - Ctb_Cnt_Devolucao_Vendas
						------------------------------------------------------------------------------------------------------------------
						
						SELECT 
							@RET_CD_FILIAL					= CD_FILIAL,							
						    @RET_DS_MOV_OP_CONTABIL			= DS_MOV_OP_CONTABIL,
							@RET_CNT_CENTRO_CUSTO			= CNT_CENTRO_CUSTO,
							@RET_DS_CENTRO_CUSTO			= DS_CENTRO_CUSTO,
							@RET_FLAG_APLICAR_CENTRO_CUSTO 	= ISNULL(FLAG_APLICAR_CENTRO_CUSTO,0),
							@RET_CD_CTB_CNT					= CD_CTB_CNT,
							@RET_CD_CTB_CNT_RED				= CD_CTB_CNT_RED						
						FROM UFD_BUSCA_CONTA_MOV (@RS_CD_EMP, @RS_CD_MOV_OP, 1, 0, @RS_CD_FILIAL)
						
						INSERT INTO ##CTB_EXP_MOV  
						
									   (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
									   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
									   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
									   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

							SELECT									   
									    @RS_CD_EMP					,								--CD_EMP
										@CD_FILIAL					,								--CD_FILIAL_EXPORT										
										@RS_CD_FILIAL				,								--CD_FILIAL
										7 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
										'DEVOLUCAO DE VENDAS'		,								--MOVIMENTO								
										'DEVOLUCAO ICMS - CREDITO'	,								--OPERACAO
										''		,													--OPERACAO_DEBITO	
										@RET_CD_CTB_CNT_RED			,								--CD_CNT_RED_CREDITO
										@RET_CD_CTB_CNT				,								--CD_CNT_CREDITO
										0							,								--CD_CNT_RED_DEBITO
										''							,								--CD_CNT_DEBITO										
										@RS_DT_EMI_NF		,										--DT_MOV
										'VR. REF. ICMS S/DEVOLUCAO DE VENDAS CONF. DOC(S) EMITIDOS',--HIST
										@RS_VLR_ICMS_ITENS,											--VLR_LANC
										'C'			,												--TP_TRANSA	
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN 1 ELSE 0 END) , --RATEIO_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_DS_CENTRO_CUSTO 	ELSE '' END),--DS_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_CNT_CENTRO_CUSTO 	ELSE '' END),--CNT_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RS_VLR_ICMS_ITENS 		ELSE 0 END),--VLR_CENTRO_CUSTO													
										'NAT MOV 1-ICMS PAGAR'				,						--ORIG_CONTA
										@RS_CD_MOV_OP		,										--COD_CONTA
										OBJECT_NAME(@@PROCID)										--NM_PROCEDURE	
										, 'X' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
									   ,'' AS CD_BC_LANC;
											
					END		

				
				IF @RS_VLR_BASE_PIS_COFINS > 0
					BEGIN
						SET @RS_VLR_BASE_PIS_COFINS = ROUND(@RS_VLR_BASE_PIS_COFINS,2)
						
						SET @VLR_COFINS = CAST((@RS_VLR_BASE_PIS_COFINS * (@PERC_COFINS / 100)) AS NUMERIC(18,2))
						SET @VLR_PIS	= CAST((@RS_VLR_BASE_PIS_COFINS * (@PERC_PIS / 100))    AS NUMERIC(18,2))
						
						SELECT 
							@RET_CD_FILIAL					= CD_FILIAL,							
						     @RET_DS_MOV_OP_CONTABIL			= DS_MOV_OP_CONTABIL,
							@RET_CNT_CENTRO_CUSTO			= CNT_CENTRO_CUSTO,
							@RET_DS_CENTRO_CUSTO			= DS_CENTRO_CUSTO,
							@RET_FLAG_APLICAR_CENTRO_CUSTO 	= ISNULL(FLAG_APLICAR_CENTRO_CUSTO,0),
							@RET_CD_CTB_CNT					= CD_CTB_CNT,
							@RET_CD_CTB_CNT_RED				= CD_CTB_CNT_RED						
						FROM UFD_BUSCA_CONTA_MOV (@RS_CD_EMP, @RS_CD_MOV_OP, 6, 1, @RS_CD_FILIAL)

						SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
							 RIGHT('00'+ CAST( DAY( @RS_DT_EMI_NF) AS VARCHAR),2) + 
						  		RIGHT('00'+  CAST( MONTH(@RS_DT_EMI_NF) AS VARCHAR),2) + 
								    RIGHT('00'+ CAST( YEAR(@RS_DT_EMI_NF)AS VARCHAR),2) + 
									   RIGHT('00'+ CAST( YEAR(@RS_CD_MOV_OP)AS VARCHAR),2) + + '2'
						
						------------------------------------------------------------------------------------------------------------------
						--COFINS A RECUPERAR - Ctb_Cnt_Movimento_Cofins_Recuperar
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV  

									   (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
									   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
									   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
									   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

							SELECT									   
									    @RS_CD_EMP					,								--CD_EMP
										@CD_FILIAL					,								--CD_FILIAL_EXPORT										
										@RS_CD_FILIAL				,								--CD_FILIAL
									    7 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
										'DEVOLUCAO DE VENDAS'		,								--MOVIMENTO								
										''							,								--OPERACAO
										'DEVOLUCAO COFINS - DEBITO'	,								--OPERACAO_DEBITO	
										0							,								--CD_CNT_RED_CREDITO
										''							,								--CD_CNT_CREDITO
										@RET_CD_CTB_CNT_RED			,								--CD_CNT_RED_DEBITO
										@RET_CD_CTB_CNT				,								--CD_CNT_DEBITO												
										@RS_DT_EMI_NF		,										--DT_MOV
										'VR. REF. COFINS S/DEVOLUCAO DE VENDAS CONF. DOC(S) EMITIDOS VALOR BASE ' + CAST(@RS_VLR_BASE_PIS_COFINS AS VARCHAR),--HIST
										@VLR_COFINS,												--VLR_LANC
										'D'			,												--TP_TRANSA	
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN 1 ELSE 0 END) , --RATEIO_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_DS_CENTRO_CUSTO 	ELSE '' END),--DS_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_CNT_CENTRO_CUSTO 	ELSE '' END),--CNT_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @VLR_COFINS 				ELSE 0 END),--VLR_CENTRO_CUSTO											
										'NAT MOV 6-COFINS PAGAR'			,						--ORIG_CONTA
										@RS_CD_MOV_OP		,										--COD_CONTA
										OBJECT_NAME(@@PROCID)										--NM_PROCEDURE	
									   , 'X' AS TIPO_LANCTO
									   , 0 AS CD_EVENTO
									   , 0  AS NR_DP
									   , 0  AS ANO
									   , @NR_CONTROLE AS NR_DOC
									   ,'' AS CD_BC_LANC;
					
						------------------------------------------------------------------------------------------------------------------
						--COFINS A RECUPERAR - Ctb_Cnt_Devolucao_Vendas
						------------------------------------------------------------------------------------------------------------------
						SELECT 
							@RET_CD_FILIAL					= CD_FILIAL,							
						    @RET_DS_MOV_OP_CONTABIL			= DS_MOV_OP_CONTABIL,
							@RET_CNT_CENTRO_CUSTO			= CNT_CENTRO_CUSTO,
							@RET_DS_CENTRO_CUSTO			= DS_CENTRO_CUSTO,
							@RET_FLAG_APLICAR_CENTRO_CUSTO 	= ISNULL(FLAG_APLICAR_CENTRO_CUSTO,0),
							@RET_CD_CTB_CNT					= CD_CTB_CNT,
							@RET_CD_CTB_CNT_RED				= CD_CTB_CNT_RED						
						FROM UFD_BUSCA_CONTA_MOV (@RS_CD_EMP, @RS_CD_MOV_OP, 6, 0, @RS_CD_FILIAL)
												
						INSERT INTO ##CTB_EXP_MOV  

						
									   (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
									   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
									   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
									   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

							SELECT									   
									    @RS_CD_EMP					,								--CD_EMP
										@CD_FILIAL					,								--CD_FILIAL_EXPORT										
										@RS_CD_FILIAL				,								--CD_FILIAL
										7 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
										'DEVOLUCAO DE VENDAS'		,								--MOVIMENTO								
										'DEVOLUCAO COFINS - CREDITO'	,							--OPERACAO
										''		,													--OPERACAO_DEBITO	
										@RET_CD_CTB_CNT_RED			,								--CD_CNT_RED_CREDITO
										@RET_CD_CTB_CNT				,								--CD_CNT_CREDITO
										0							,								--CD_CNT_RED_DEBITO
										''							,								--CD_CNT_DEBITO											
										@RS_DT_EMI_NF		,										--DT_MOV
										'VR. REF. COFINS S/DEVOLUCAO DE VENDAS CONF. DOC(S) EMITIDOS VALOR BASE ' + CAST(@RS_VLR_BASE_PIS_COFINS AS VARCHAR),--HIST
										@VLR_COFINS,												--VLR_LANC
										'C'			,												--TP_TRANSA										
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN 1 ELSE 0 END) , --RATEIO_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_DS_CENTRO_CUSTO 	ELSE '' END),--DS_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_CNT_CENTRO_CUSTO 	ELSE '' END),--CNT_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @VLR_COFINS 				ELSE 0 END),--VLR_CENTRO_CUSTO													
										'NAT MOV 6-COFINS PAGAR'			,						--ORIG_CONTA
										@RS_CD_MOV_OP		,										--COD_CONTA										
										OBJECT_NAME(@@PROCID)										--NM_PROCEDURE	
									   , 'X' AS TIPO_LANCTO
									   , 0 AS CD_EVENTO
									   , 0  AS NR_DP
									   , 0  AS ANO
									   , @NR_CONTROLE AS NR_DOC
									   ,'' AS CD_BC_LANC;
										
						------------------------------------------------------------------------------------------------------------------
						--PIS A RECUPERAR - Ctb_Cnt_Movimento_Pis_Recuperar
						------------------------------------------------------------------------------------------------------------------						
						SELECT 
							@RET_CD_FILIAL					= CD_FILIAL,							
						    @RET_DS_MOV_OP_CONTABIL			= DS_MOV_OP_CONTABIL,
							@RET_CNT_CENTRO_CUSTO			= CNT_CENTRO_CUSTO,
							@RET_DS_CENTRO_CUSTO			= DS_CENTRO_CUSTO,
							@RET_FLAG_APLICAR_CENTRO_CUSTO 	= ISNULL(FLAG_APLICAR_CENTRO_CUSTO,0),
							@RET_CD_CTB_CNT					= CD_CTB_CNT,
							@RET_CD_CTB_CNT_RED				= CD_CTB_CNT_RED						
						FROM UFD_BUSCA_CONTA_MOV (@RS_CD_EMP, @RS_CD_MOV_OP, 4, 1, @RS_CD_FILIAL)

						SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
							 RIGHT('00'+ CAST( DAY( @RS_DT_EMI_NF) AS VARCHAR),2) + 
								RIGHT('00'+  CAST( MONTH(@RS_DT_EMI_NF) AS VARCHAR),2) + 
								    RIGHT('00'+ CAST( YEAR(@RS_DT_EMI_NF)AS VARCHAR),2) + 
									   RIGHT('00'+ CAST( YEAR(@RS_CD_MOV_OP)AS VARCHAR),2) + '3' 
						
						INSERT INTO ##CTB_EXP_MOV  
						
									   (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
									   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
									   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
									   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

		
							SELECT									   
									    @RS_CD_EMP					,								--CD_EMP
										@CD_FILIAL					,							--CD_FILIAL_EXPORT										
										@RS_CD_FILIAL				,								--CD_FILIAL
										7 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
										'DEVOLUCAO DE VENDAS'		,								--MOVIMENTO								
										''							,								--OPERACAO
										'DEVOLUCAO PIS - DEBITO'	,								--OPERACAO_DEBITO	
										0							,								--CD_CNT_RED_CREDITO
										''							,								--CD_CNT_CREDITO
										@RET_CD_CTB_CNT_RED			,								--CD_CNT_RED_DEBITO
										@RET_CD_CTB_CNT				,								--CD_CNT_DEBITO												
										@RS_DT_EMI_NF		,										--DT_MOV
										'VR. REF. PIS S/DEVOLUCAO DE VENDAS CONF. DOC(S) EMITIDOS VALOR BASE ' + CAST(@RS_VLR_BASE_PIS_COFINS AS VARCHAR),--HIST
										@VLR_PIS	,												--VLR_LANC
										'D'			,												--TP_TRANSA	
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN 1 ELSE 0 END) , --RATEIO_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_DS_CENTRO_CUSTO 	ELSE '' END),--DS_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_CNT_CENTRO_CUSTO 	ELSE '' END),--CNT_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @VLR_PIS 				ELSE 0 END),--VLR_CENTRO_CUSTO													
										'NAT MOV 4-PIS PAGAR'			,						--ORIG_CONTA
										@RS_CD_MOV_OP		,										--COD_CONTA
										OBJECT_NAME(@@PROCID)										--NM_PROCEDURE											
									   , 'X' AS TIPO_LANCTO
									   , 0 AS CD_EVENTO
									   , 0  AS NR_DP
									   , 0  AS ANO
									   ,@NR_CONTROLE AS NR_DOC
									   ,'' AS CD_BC_LANC;
					
						------------------------------------------------------------------------------------------------------------------
						--PIS A RECUPERAR - Ctb_Cnt_Devolucao_Vendas
						------------------------------------------------------------------------------------------------------------------
						SELECT 
							@RET_CD_FILIAL					= CD_FILIAL,							
						    @RET_DS_MOV_OP_CONTABIL			= DS_MOV_OP_CONTABIL,
							@RET_CNT_CENTRO_CUSTO			= CNT_CENTRO_CUSTO,
							@RET_DS_CENTRO_CUSTO			= DS_CENTRO_CUSTO,
							@RET_FLAG_APLICAR_CENTRO_CUSTO 	= ISNULL(FLAG_APLICAR_CENTRO_CUSTO,0),
							@RET_CD_CTB_CNT					= CD_CTB_CNT,
							@RET_CD_CTB_CNT_RED				= CD_CTB_CNT_RED						
						FROM UFD_BUSCA_CONTA_MOV (@RS_CD_EMP, @RS_CD_MOV_OP, 4, 0, @RS_CD_FILIAL)
						
						INSERT INTO ##CTB_EXP_MOV  

									   (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
									   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
									   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
									   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

							SELECT									   
									    @RS_CD_EMP					,								--CD_EMP
										@CD_FILIAL					,								--CD_FILIAL_EXPORT										
										@RS_CD_FILIAL				,								--CD_FILIAL
										7 AS CD_MOVIMENTO			,								--CODIGO MOVIMENTO
										'DEVOLUCAO DE VENDAS'		,								--MOVIMENTO								
										'DEVOLUCAO PIS - CREDITO'	,								--OPERACAO
										''		,													--OPERACAO_DEBITO		
										@RET_CD_CTB_CNT_RED			,								--CD_CNT_RED_CREDITO
										@RET_CD_CTB_CNT				,								--CD_CNT_CREDITO
										0							,								--CD_CNT_RED_DEBITO
										''							,								--CD_CNT_DEBITO											
										@RS_DT_EMI_NF		,										--DT_MOV
										'VR. REF. PIS S/DEVOLUCAO DE VENDAS CONF. DOC(S) EMITIDOS VALOR BASE ' + CAST(@RS_VLR_BASE_PIS_COFINS AS VARCHAR),--HIST
										@VLR_PIS	,												--VLR_LANC
										'C'			,												--TP_TRANSA	
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN 1 ELSE 0 END) , --RATEIO_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_DS_CENTRO_CUSTO 	ELSE '' END),--DS_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @RET_CNT_CENTRO_CUSTO 	ELSE '' END),--CNT_CENTRO_CUSTO
										(CASE WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 1 THEN @VLR_PIS 				ELSE 0 END),--VLR_CENTRO_CUSTO												
										'NAT MOV 4-PIS PAGAR'				,						--ORIG_CONTA
										@RS_CD_MOV_OP		,										--COD_CONTA
										OBJECT_NAME(@@PROCID)										--NM_PROCEDURE	
									   , 'X' AS TIPO_LANCTO
									   , 0 AS CD_EVENTO
									   , 0  AS NR_DP
									   , 0  AS ANO
									   , @NR_CONTROLE AS NR_DOC
									   ,'' AS CD_BC_LANC;
					
										
					END							 					
								 
				--Prximo registro				
				FETCH NEXT FROM RS_RESULT INTO 
						@RS_CD_EMP, 
						@RS_CD_FILIAL,
						@RS_NM_FANT,
						@RS_DT_EMI_NF,
						@RS_DS_MOV_OP,
						@RS_CD_MOV_OP,
						@RS_VLR_BASE_PIS_COFINS,
						@RS_VLR_ICMS_ITENS

			END
		
		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	
END

END TRY
BEGIN CATCH
	CLOSE RS_RESULT
	DEALLOCATE RS_RESULT	

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH					  